var samplePageObj = {
  // 간트차트 CSS
  externalStyles: ['../assets/css/ganttChart.css'],
  // 샘플 타이틀
  title: 'HTML 타입 컬럼',
  subtitle: 'HTML Type을 활용한 시트 예제입니다.',
  // 샘플 설명
  desc: '시트 내에 특정 컬럼의 Type을 HTML로 지정하시면 해당 컬럼에 다양한 기능을 부여하실 수 있습니다.<br>HTML Type으로 지정된 컬럼은 기본적으로 편집이 불가능 합니다.',

  // 객체 초기화 구문
  init: {
    Def: {
      Header: { Spanned: 1 },
      Col: { Spanned: 1 },
      Spacer: {
        CanFocus: 0,
        Width: 5
      },
      Row: { Height: 35 }
    },
    Cfg: {
      SearchMode: 2,
      MainCol: 'cls',
      HeaderMerge: 3,
      PrevColumnMerge: 0
    },
    LeftCols: [
      {
        Header: [
          '프로젝트명',
          '프로젝트명'
        ],
        Type: 'Text',
        Name: 'cls',
        Width: '160',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: [
          'PM',
          'PM'
        ],
        Type: 'Text',
        Name: 'pm',
        Width: '90',
        Align: 'Center',
        CanEdit: 0
      }
    ],
    Cols: [
      {
        Header: [
          '시작일',
          '시작일'
        ],
        Type: 'Date',
        Name: 'sDate',
        Width: '100',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: [
          '완료일',
          '완료일'
        ],
        Type: 'Date',
        Name: 'eDate',
        Width: '100',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: [
          '경과율',
          '경과율'
        ],
        Type: 'Int',
        Name: 'percent',
        Width: '70',
        Align: 'Right',
        CanEdit: 0,
        Format: '#,##0.0\\%'
      },
      {
        Header: [
          '2017',
          '1분기'
        ],
        Type: 'Html',
        Name: 'gant',
        Width: '80',
        Align: 'Center',
        CanEdit: 0,
        RelWidth: 1
      },
      {
        Header: [
          '2017',
          '2분기'
        ],
        Type: 'Html',
        Name: 'gant1',
        Width: '80',
        Align: 'Center',
        CanEdit: 0,
        RelWidth: 1
      },
      {
        Header: [
          '2017',
          '3분기'
        ],
        Type: 'Html',
        Name: 'gant2',
        Width: '80',
        Align: 'Center',
        CanEdit: 0,
        RelWidth: 1
      },
      {
        Header: [
          '2017',
          '4분기'
        ],
        Type: 'Html',
        Name: 'gant3',
        Width: '80',
        Align: 'Center',
        CanEdit: 0,
        RelWidth: 1
      },
      {
        Header: [
          '2018',
          '1분기'
        ],
        Type: 'Html',
        Name: 'gantt5',
        Width: '80',
        Align: 'Center',
        CanEdit: 0,
        RelWidth: 1
      },
      {
        Header: [
          '2018',
          '2분기'
        ],
        Type: 'Html',
        Name: 'gant4',
        Width: '80',
        Align: 'Center',
        CanEdit: 0,
        RelWidth: 1
      },
      {
        Header: [
          '2018',
          '3분기'
        ],
        Type: 'Html',
        Name: 'gant5',
        Width: '80',
        Align: 'Center',
        CanEdit: 0,
        RelWidth: 1
      },
      {
        Header: [
          '2018',
          '4분기'
        ],
        Type: 'Html',
        Name: 'gant6',
        Width: '80',
        Align: 'Center',
        CanEdit: 0,
        RelWidth: 1
      },

      {
        Header: [
          '위험도',
          '위험도'
        ],
        Type: 'Html',
        Name: 'ALERT',
        Width: '80',
        Align: 'Center',
        CanEdit: 1,
        Format: {
          0: '<div class=\'alertCircle\' style=\'background-color:#009688;\'>안전</div>',
          1: '<div class=\'alertCircle\' style=\'background-color:#ff9800;\'>주의</div>',
          2: '<div class=\'alertCircle\' style=\'background-color:#db4437;\'>위험</div>'
        }
      },
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {

  },

  // event구문
  event: {
    onDataLoad: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      psd = new Date(2017, 0, 1, 0, 0, 0, 0);// 그래프의  시작일
      var ped = new Date(2018, 12, 31, 0, 0, 0, 0);// 그래프의 종료일

      // 화면에 표시되는 총 기간 일
      pdays = ((((ped - psd) / 1000) / 60) / 60) / 24;

      var sheet = evtParam.sheet;
      var row = sheet.getFirstRow();

      var totalcolor = '#4d9dff';
      var ratecolor = '#fea176';
      var psd;
      var pdays;

      while (row != null) {
        // 작업시작일
        var s = row.sDate;
        var wsd = new Date(s);
        var wpos = ((((wsd - psd) / 1000) / 60) / 60) / 24;
        var wposRate = parseInt((wpos / pdays) * 100, 10);

        // 작업종료일
        var e = row.eDate;
        var wed = new Date(e);

        wdays = ((((wed - wsd) / 1000) / 60) / 60) / 24;
        var eposRate = parseInt((wdays / pdays) * 100, 10);
        var sDate = wsd.getFullYear() + '/' + (wsd.getMonth() + 1) + '/' + wsd.getDate();
        var eDate = wed.getFullYear() + '/' + (wed.getMonth() + 1) + '/' + wed.getDate();
        // 공정률
        var rate = row.percent;

        if (rate == 100) {
          comment = '완료';
        } else if (rate == 0) {
          comment = '시공전';
        } else {
          comment = '(' + row.pm + ') ' + rate + '% 진행중';
        }
        var tooltip = row.cls + '\n' + sDate + ' ~ ' + eDate + '\n' + comment;

        row.gant = '<div style=\'width:100%;height:30px\' >'
                      + '<div class=\'ganttBarMain\' title=\'' + tooltip + '\' style=\'left:' + wposRate + '%;width:' + eposRate + '%;background-color:' + totalcolor + '\'>'
                      + '<div style=\'border-radius:40px;background-color:' + ratecolor + ';height:100%;width:' + rate + '%\'></div>'
                      + '<span style=\'color:#338844;display:inline;min-width:26px\'>'
                      + comment
                      + '</span>'
                      + '</div>'
                      + '</div>';

        sheet.setMergeRange(row, 'gant', row, 'gant6');
        row = sheet.getNextRow(row);
      }
    }
  },
  // data
  data: [
    {
      cls: '인사동 A타워 시공',
      pm: '황책임',
      sDate: '2017-01-20',
      eDate: '2018-09-30',
      percent: 71,
      ALERT: 1,
      Items: [
        {
          cls: '지반 조사',
          pm: '이수석',
          sDate: '2017-01-25',
          eDate: '2017-02-15',
          percent: 100,
          ALERT: 0
        },
        {
          cls: '측량',
          pm: '이수석',
          sDate: '2017-02-16',
          eDate: '2017-04-05',
          percent: 100,
          ALERT: 0
        },
        {
          cls: '공통가설',
          pm: '안수석',
          sDate: '2017-04-06',
          eDate: '2017-07-01',
          percent: 100,
          ALERT: 0
        },
        {
          cls: '흑파기/흙막기',
          pm: '안수석',
          sDate: '2017-04-06',
          eDate: '2017-08-15',
          percent: 100,
          ALERT: 0
        },
        {
          cls: '기초지정',
          pm: '김선임',
          sDate: '2017-06-01',
          eDate: '2017-08-01',
          percent: 100,
          ALERT: 0
        },
        {
          cls: '골조공사',
          pm: '박주임',
          sDate: '2017-08-10',
          eDate: '2017-12-31',
          percent: 100,
          ALERT: 0,
          Items: [
            {
              cls: '철골조적',
              pm: '신책임',
              sDate: '2017-09-20',
              eDate: '2018-04-30',
              percent: 92,
              ALERT: 0
            },
            {
              cls: '전기공사',
              pm: '하수석',
              sDate: '2017-08-25',
              eDate: '2018-05-15',
              percent: 65,
              ALERT: 2
            },
            {
              cls: '설비공사',
              pm: '김선임',
              sDate: '2017-11-15',
              eDate: '2018-06-30',
              percent: 69,
              ALERT: 0
            }
          ]
        },
        {
          cls: '마감공사',
          pm: '신책임',
          sDate: '2018-04-01',
          eDate: '2018-09-30',
          percent: 0,
          ALERT: 0
        }
      ]
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
